% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bootstrap-SE.R
\name{bootstrap.se}
\alias{bootstrap.se}
\title{Non-parametric bootstrap Standard Error for the ATT}
\usage{
bootstrap.se(obj, Y, max.iter = 1000)
}
\arguments{
\item{obj}{MatchIt Object}

\item{Y}{Response Vector}

\item{max.iter}{Maximum bootstrap Iterations. Default is 1000.}
}
\value{
SE for the ATT of \code{Y}
}
\description{
Calculate the SE for the ATT with a non-parametric bootstrap method.
}
\examples{
\dontrun{
  library(MatchIt)
  data("lalonde")
  m.out  <- matchit(treat ~ educ + black, data = lalonde)
  att(obj = m.out, Y = lalonde$re78)
  bootstrap.se(obj = m.out, Y = lalonde$re78)
}
}

