% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cbind.R
\name{cbind2-method}
\alias{cbind2-method}
\alias{cbind2,TsparseMatrix,TsparseMatrix-method}
\alias{cbind2,TsparseMatrix,sparseVector-method}
\alias{cbind2,sparseVector,TsparseMatrix-method}
\alias{cbind2,CsparseMatrix,sparseVector-method}
\alias{cbind2,sparseVector,CsparseMatrix-method}
\alias{cbind2,sparseVector,sparseVector-method}
\alias{cbind2,RsparseMatrix,RsparseMatrix-method}
\alias{cbind2,TsparseMatrix,RsparseMatrix-method}
\alias{cbind2,RsparseMatrix,TsparseMatrix-method}
\alias{cbind2,RsparseMatrix,numeric-method}
\alias{cbind2,RsparseMatrix,integer-method}
\alias{cbind2,RsparseMatrix,logical-method}
\alias{cbind2,RsparseMatrix,sparseVector-method}
\alias{cbind2,numeric,RsparseMatrix-method}
\alias{cbind2,integer,RsparseMatrix-method}
\alias{cbind2,logical,RsparseMatrix-method}
\alias{cbind2,sparseVector,RsparseMatrix-method}
\title{Concatenate sparse matrices by columns}
\usage{
\S4method{cbind2}{TsparseMatrix,TsparseMatrix}(x, y)

\S4method{cbind2}{TsparseMatrix,sparseVector}(x, y)

\S4method{cbind2}{sparseVector,TsparseMatrix}(x, y)

\S4method{cbind2}{CsparseMatrix,sparseVector}(x, y)

\S4method{cbind2}{sparseVector,CsparseMatrix}(x, y)

\S4method{cbind2}{sparseVector,sparseVector}(x, y)

\S4method{cbind2}{RsparseMatrix,RsparseMatrix}(x, y)

\S4method{cbind2}{TsparseMatrix,RsparseMatrix}(x, y)

\S4method{cbind2}{RsparseMatrix,TsparseMatrix}(x, y)

\S4method{cbind2}{RsparseMatrix,numeric}(x, y)

\S4method{cbind2}{RsparseMatrix,integer}(x, y)

\S4method{cbind2}{RsparseMatrix,logical}(x, y)

\S4method{cbind2}{RsparseMatrix,sparseVector}(x, y)

\S4method{cbind2}{numeric,RsparseMatrix}(x, y)

\S4method{cbind2}{integer,RsparseMatrix}(x, y)

\S4method{cbind2}{logical,RsparseMatrix}(x, y)

\S4method{cbind2}{sparseVector,RsparseMatrix}(x, y)
}
\arguments{
\item{x}{First matrix to concatenate.}

\item{y}{Second matrix to concatenate.}
}
\value{
A sparse matrix (storage order varying depending on the input types).
}
\description{
`cbind2` method for the CSR and COO sparse matrix and
sparse vector classes from `Matrix`,
taking the most efficient route for the concatenation according to the input types.
}
\examples{
library(Matrix)
library(MatrixExtra)
set.seed(1)
X <- rsparsematrix(3, 4, .3)
X <- as(X, "TsparseMatrix")
inherits(cbind2(X, X), "TsparseMatrix")
}
