% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deltaVP.r
\name{deltaVP}
\alias{deltaVP}
\title{Slope of the saturation vapor pressure curve}
\usage{
deltaVP(Tmean = NULL, Tmax = NULL, Tmin = NULL)
}
\arguments{
\item{Tmean}{Mean Temperature [degreeC] (mean daily, mean hourly, etc. air temperature)}

\item{Tmax}{maximum temperature during 24-hour period [degreeC] (if Tmean is missing)}

\item{Tmin}{minimum temperature during 24-hour period [degreeC] (if Tmean is missing)}
}
\value{
slope of the saturation vapor pressure curve [kPa/degreeC]
}
\description{
Slope of the saturation vapor pressure curve [kPa/degreeC].
}
\details{
valid for daily, hourly and shorter periods
}
\note{
eq. 13 of reference
}
\examples{
deltaVP(Tmax = 34.8, Tmin = 25.6)
deltaVP(Tmean = 30.2)
}
\references{
Allen, R. G., Pereira, L. S., Raes, D., & Smith, M. (1998). Crop evapotranspiration-Guidelines for computing crop water requirements-FAO Irrigation and drainage paper 56. FAO, Rome, 300(9).
}
