\name{mesh3dL_to_cgalMeshL}
\alias{mesh3dL_to_cgalMeshL}
\title{Convert mesh3d objects to cgalMesh objects}
\description{Utility function that turns an observer/mesh list of mesh3d objects into an observer/mesh list with cgalMesh objects.}
\usage{
mesh3dL_to_cgalMeshL(x)
}
\arguments{
  \item{x}{\code{list} of observer/mesh objects with a structure as generated by \code{\link[MeshAgreement]{read_mesh_obs}}, but with \code{\link[rgl]{mesh3d}} objects instead of \code{\link[cgalMeshes]{cgalMesh}} objects.}
}
\value{\code{list} of observer/mesh objects as generated by \code{\link[MeshAgreement]{read_mesh}}.}
\seealso{
\code{\link[MeshAgreement]{read_mesh}},
\code{\link[cgalMeshes]{cgalMesh}},
\code{\link[rgl]{mesh3d}}
}
\examples{
heartL <- mesh3dL_to_cgalMeshL(data_heart_obsL)
get_mesh_info(heartL)
}
