% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/someMeshes.R
\name{torusMesh}
\alias{torusMesh}
\title{Torus mesh}
\usage{
torusMesh(R, r, nu = 50, nv = 30, rgl = TRUE)
}
\arguments{
\item{R, r}{major and minor radii, positive numbers}

\item{nu, nv}{numbers of subdivisions, integers (at least 3)}

\item{rgl}{Boolean, whether to return a \strong{rgl} mesh}
}
\value{
A triangle \strong{rgl} mesh (class \code{mesh3d}) if
  \code{rgl=TRUE}, otherwise a \code{cgalMesh} list (vertices, faces,
  and normals).
}
\description{
Triangle mesh of a torus.
}
\examples{
library(MeshesOperations)
library(rgl)
mesh <- torusMesh(R = 3, r = 1)
open3d(windowRect = c(50, 50, 562, 562))
view3d(0, 0, zoom = 0.75)
shade3d(mesh, color = "green")
wire3d(mesh)
}
