% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateSharpness.R
\name{calculateSharpness}
\alias{calculateSharpness}
\title{Calculate Sharpness (of a Chromatographic Peak)}
\usage{
calculateSharpness(peakData, pts)
}
\arguments{
\item{peakData}{A vector containing characteristic information about a chromatographic peak - including the retention time range}

\item{pts}{A 2D matrix containing the retention time and intensity values of a chromatographic peak}
}
\value{
The Sharpness value (double)
}
\description{
Calculate Sharpness of the integrated region of a chromatographic peak. The Sharpness is found by determining the sum of the
difference between the intensities of each adjacent pair of points on the peak normalized by the intensity of the peak boundaries.
}
\details{
This function repurposed from Zhang et al. For details, see Zhang, W., & Zhao, P. X. (2014). Quality evaluation of extracted
ion chromatograms and chromatographic peaks in liquid chromatography/mass spectrometry-based metabolomics data. BMC Bioinformatics,
15(Suppl 11), S5. https://doi.org/10.1186/1471-2105-15-S11-S5
}
\examples{
# Calculate Sharpness for a peak
data(ex_pts)
data(ex_peakData)
sharpness <- calculateSharpness(peakData = ex_peakData, pts = ex_pts)

}
