% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPeakQualityMetrics.R
\name{getPeakQualityMetrics}
\alias{getPeakQualityMetrics}
\title{Calculate the 12 Peak Quality Metrics}
\usage{
getPeakQualityMetrics(eicEvalData, eicLabels_df, flatness.factor = 0.05)
}
\arguments{
\item{eicEvalData}{An object of class evalObj containing the required chromatographic peak information}

\item{eicLabels_df}{A dataframe with EICNos in the first column and Labels in the second column}

\item{flatness.factor}{A numeric value between 0 and 1 that allows the user to adjust the sensitivity of the function to noise. This
function calculates the difference between each adjacent pair of points; any value found to be less than flatness.factor * maximum
intensity is set to 0.}
}
\value{
An Mx14 matrix where M is equal to the number of peaks. There are 14 columns in total, including one column for each of the twelve
metrics, one column for EIC numbers, and one column for the class label.
}
\description{
Wrapper function for calculating the each of the 12 peak quality metrics for each feature.
}
\examples{
# # calculate peak quality metrics for development dataset
\donttest{pqMetrics_development <- getPeakQualityMetrics(eicEvalData = eicEval_development,
eicLabels_df = eicLabels_development)}

}
