% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Metalonda.R
\name{metalondaAll}
\alias{metalondaAll}
\title{Metagenomic Longitudinal Differential Abundance Analysis for all Features}
\usage{
metalondaAll(Count, Time, Group, ID, n.perm = 500, fit.method = "nbinomial",
  num.intervals = 100, parall = FALSE, pvalue.threshold = 0.05,
  adjust.method = "BH", time.unit = "days", norm.method = "none",
  prefix = "Output")
}
\arguments{
\item{Count}{Count matrix of all features}

\item{Time}{Time label of all samples}

\item{Group}{Group label of all samples}

\item{ID}{individual ID label for samples}

\item{n.perm}{number of permutations}

\item{fit.method}{The fitting method (NB, LOWESS)}

\item{num.intervals}{The number of time intervals at which metalonda test differential abundance}

\item{parall}{logic to indicate whether to use multicore}

\item{pvalue.threshold}{p-value threshold cutoff}

\item{adjust.method}{Multiple testing correction methods}

\item{time.unit}{time unit used in the Time vector (days, weeks, months, etc.)}

\item{norm.method}{normalization method to be used to normalize count matrix (CSS, median-ratio, etc.)}

\item{prefix}{prefix for the output figure}
}
\value{
Returns a list of the significant features a long with their significant time intervals
}
\description{
Identify significant features and their significant time interval
}
\references{
Ahmed Metwally (ametwa2@uic.edu)
}

