% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiRegion_SIM.R
\name{treeMultiRegionSimulator}
\alias{treeMultiRegionSimulator}
\title{treeMultiRegionSimulator}
\description{
an R6 class representing the methylation state of GpGs in different genomic
structures in the nodes of a tree.

The whole CpG sequence is an object of class combiStructureGenerator.
Each genomic structure in it is contained in an object of class singleStructureGenerator.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{Branch}}{Public attribute: List containing objects of class combiStructureGenerator}

\item{\code{branchLength}}{Public attribute: Vector with the corresponding branch lengths of each $Branch element}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-treeMultiRegionSimulator-treeEvol}{\code{treeMultiRegionSimulator$treeEvol()}}
\item \href{#method-treeMultiRegionSimulator-new}{\code{treeMultiRegionSimulator$new()}}
\item \href{#method-treeMultiRegionSimulator-clone}{\code{treeMultiRegionSimulator$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-treeMultiRegionSimulator-treeEvol"></a>}}
\if{latex}{\out{\hypertarget{method-treeMultiRegionSimulator-treeEvol}{}}}
\subsection{Method \code{treeEvol()}}{
Simulate CpG dinucleotide methylation state evolution along a tree.
The function splits a given tree and simulates evolution along its
branches. It recursively simulates evolution in all of the subtrees in the given tree
until the tree leafs
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{treeMultiRegionSimulator$treeEvol(
  Tree,
  dt = 0.01,
  parent_index = 1,
  testing = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{Tree}}{String. Tree in Newick format. When called recursivelly it is given the corresponding subtree.}

\item{\code{dt}}{Length of SSE time steps.}

\item{\code{parent_index}}{Default 1. When called recursivelly it is given the corresponding parent branch index.}

\item{\code{testing}}{Default FALSE. TRUE for testing purposes.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
NULL
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-treeMultiRegionSimulator-new"></a>}}
\if{latex}{\out{\hypertarget{method-treeMultiRegionSimulator-new}{}}}
\subsection{Method \code{new()}}{
Create a new treeMultiRegionSimulator object.
$Branch is a list for the tree branches, its first element represents the tree root.

Note that one of either infoStr or rootData needs to be given. Not both, not neither.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{treeMultiRegionSimulator$new(
  infoStr = NULL,
  rootData = NULL,
  tree,
  params = NULL,
  dt = 0.01,
  testing = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{infoStr}}{A data frame containing columns 'n' for the number of sites, and 'globalState' for the favoured global methylation state.
If initial equilibrium frequencies are given the dataframe must contain 3 additional columns: 'u_eqFreq', 'p_eqFreq' and 'm_eqFreq'}

\item{\code{rootData}}{combiStructureGenerator object. When given, the simulation uses its parameter values.}

\item{\code{tree}}{tree}

\item{\code{params}}{Default NULL. When given: data frame containing model parameters. Note that rootData is given, its parameter values are used.}

\item{\code{dt}}{length of the dt time steps for the SSE evolutionary process}

\item{\code{testing}}{Default FALSE. TRUE for testing output.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{treeMultiRegionSimulator} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-treeMultiRegionSimulator-clone"></a>}}
\if{latex}{\out{\hypertarget{method-treeMultiRegionSimulator-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{treeMultiRegionSimulator$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
