% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r_squared_bernoulli.R
\name{r_squared_bernoulli}
\alias{r_squared_bernoulli}
\title{Pseudo R-Squared regarding Bernoulli deviance}
\usage{
r_squared_bernoulli(actual, predicted, w = NULL, reference_mean = NULL, ...)
}
\arguments{
\item{actual}{Observed values.}

\item{predicted}{Predicted values.}

\item{w}{Optional case weights.}

\item{reference_mean}{An optional reference mean used to derive the null deviance. Recommended in out-of-sample applications.}

\item{...}{Further arguments passed to \code{r_squared}.}
}
\value{
A numeric vector of length one.
}
\description{
Wrapper to \code{r_squared} with \code{deviance_function = deviance_bernoulli}.
}
\details{
The deviance gain is calculated regarding the null model derived from the actual values. While fine for in-sample considerations, this is only an approximation for out-of-sample considerations. There, it is recommended to calculate null deviance regarding the in-sample (weighted) mean. This value can be passed by the argument \code{reference_mean}.
}
\examples{
r_squared(c(0, 0, 1, 1), c(0.1, 0.1, 0.9, 0.8), w = 1:4,
  deviance_function = deviance_bernoulli)
r_squared_bernoulli(c(0, 0, 1, 1), c(0.1, 0.1, 0.9, 0.8), w = 1:4)
}
\seealso{
\code{\link{r_squared}}.
}
