% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{sample_stochastic_matrix}
\alias{sample_stochastic_matrix}
\title{Sample a stochastic matrix}
\usage{
sample_stochastic_matrix(x, prob)
}
\arguments{
\item{x}{a matrix}

\item{prob}{a matrix, it must have number of columns equal to the number of columns of \code{x} and rows that sum
to one}
}
\value{
a matrix whose dimensions equal the original \code{x}
}
\description{
\code{x} is a matrix with arbitrary number of rows but whose columns
are equal to the number of bins that the stochastic matrix \code{prob} parameterizes
a distribution over. Each row of \code{x} gives a distribution of counts over bins
and is resampled according to \code{prob}. It is conceptually similar to
"stochastically" distributing the matrix as \code{x \%*\% prob}, which gives the
expectation.
}
