% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrixnorm.R
\name{MLmatrixnorm}
\alias{MLmatrixnorm}
\title{Maximum likelihood estimation for matrix normal distributions}
\usage{
MLmatrixnorm(data, row.mean = FALSE, col.mean = FALSE,
  row.variance = "none", col.variance = "none", tol = 10 *
  .Machine$double.eps^0.5, max.iter = 100, U, V, ...)
}
\arguments{
\item{data}{Either a list of matrices or a 3-D array with matrices in
dimensions 1 and 2, indexed by dimension 3.}

\item{row.mean}{By default, \code{FALSE}. If \code{TRUE}, will fit a
common mean within each row. If both this and \code{col.mean} are
\code{TRUE}, there will be a common mean for the entire matrix.}

\item{col.mean}{By default, \code{FALSE}. If \code{TRUE}, will fit a
common mean within each row. If both this and \code{row.mean} are
\code{TRUE}, there will be a common mean for the entire matrix.}

\item{row.variance}{Imposes a variance structure on the rows. Either
'none', 'AR(1)', 'CS' for 'compound symmetry', 'Correlation' for a
correlation matrix, or 'Independence' for
independent and identical variance across the rows.
Only positive correlations are allowed for AR(1) and CS covariances.
Note that while maximum likelihood estimators are available (and used) for
the unconstrained variance matrices, \code{optim} is used for any
constraints so it may be considerably slower.}

\item{col.variance}{Imposes a variance structure on the columns.
Either 'none', 'AR(1)', 'CS', 'Correlation', or 'Independence'.
Only positive correlations are allowed for
AR(1) and CS.}

\item{tol}{Convergence criterion. Measured against square deviation
between iterations of the two variance-covariance matrices.}

\item{max.iter}{Maximum possible iterations of the algorithm.}

\item{U}{(optional) Can provide a starting point for the \code{U} matrix.
By default, an identity matrix.}

\item{V}{(optional) Can provide a starting point for the \code{V} matrix.
By default, an identity matrix.}

\item{...}{(optional) additional arguments can be passed to \code{optim}
if using restrictions on the variance.}
}
\value{
Returns a list with a the following elements:
\describe{
      \item{\code{mean}}{the mean matrix}
      \item{\code{scaling}}{the scalar variance parameter
           (the first entry of the covariances are restricted to unity)}
      \item{\code{U}}{the between-row covariance matrix}
      \item{\code{V}}{the between-column covariance matrix}
      \item{\code{iter}}{the number of iterations}
      \item{\code{tol}}{the squared difference between iterations of
           the variance matrices at the time of stopping}
      \item{\code{logLik}}{vector of log likelihoods at each iteration.}
      \item{\code{convergence}}{a convergence flag, \code{TRUE} if converged.}
      \item{\code{call}}{The (matched) function call.}
   }
}
\description{
Maximum likelihood estimates exist for \eqn{N > max(p/q,q/p)+1} and are
unique for \eqn{N > max(p,q)}. This finds the estimate for the mean and then
alternates between estimates for the \eqn{U} and \eqn{V} matrices until
convergence. An AR(1), compound symmetry, correlation matrix, or independence
restriction can be proposed for either or both variance matrices. However, if
they are inappropriate for the data, they may fail with a warning.
}
\examples{
set.seed(20180202)
# simulating from a given density
A <- rmatrixnorm(n=100,mean=matrix(c(100,0,-100,0,25,-1000),nrow=2),
   L=matrix(c(2,1,0,.1),nrow=2),list=TRUE)
# finding the parameters by ML estimation
results=MLmatrixnorm(A, tol = 1e-5)
print(results)


}
\references{
Pierre Dutilleul.  The MLE algorithm for the matrix normal distribution.
    Journal of Statistical Computation and Simulation, (64):105–123, 1999.

    Gupta, Arjun K, and Daya K Nagar. 1999. Matrix Variate Distributions.
    Vol. 104. CRC Press. ISBN:978-1584880462
}
\seealso{
\code{\link{rmatrixnorm}} and \code{\link{MLmatrixt}}
}
