% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_intervals.R
\name{plot_intervals}
\alias{plot_intervals}
\title{Plot posterior uncertainty intervals from a MixSIAR model}
\usage{
plot_intervals(
  combined,
  toplot = "p",
  levels = NULL,
  groupby = "factor",
  savepdf = FALSE,
  filename = "post_intervals",
  ...
)
}
\arguments{
\item{combined}{list, output from \code{\link{combine_sources}} function}

\item{toplot}{vector, which parameters to plot? Options are similar to \code{\link{summary_stat}}: 
\itemize{
 \item \code{"p"}: plots all proportions (default)
 \item \code{"global"}: plots overall proportions
 \item \code{"fac1"}: plots factor 1 proportions
 \item \code{"fac2"}: plots factor 2 proportions
 \item \code{"epsilon"}: plots multiplicative error terms
 \item \code{"sd"}: plots random effect SD terms
}}

\item{levels}{vector if \code{toplot="fac1"} or \code{toplot="fac2"}, which level(s) to plot? Plots all levels if \code{level=NULL} (default). Specify levels as a vector, e.g. in wolves ex, \code{levels=1} to plot Region 1, \code{levels=c(1,2)} to plot Regions 1 and 2.}

\item{groupby}{character, group by "factor" or "source"? I.e. in wolves example, group proportions by Region 1, Region 2, Region 3
(\code{groupby="factor"}) vs. Deer, Marine Mammals, Salmon (\code{groupby="source"}). Currently only \code{"factor"} is implemented.}

\item{savepdf}{\code{TRUE/FALSE}, save plot as .pdf file (in working directory)?}

\item{filename}{character, file name to save results as (\code{.pdf} will be appended automatically)}

\item{...}{additional arguments to pass to \href{http://mc-stan.org/bayesplot/reference/MCMC-intervals.html}{bayesplot::mcmc_intervals}. For example:
\itemize{
 \item \code{prob}: sets inner (thick) interval (default = 50\%)
 \item \code{prob_outer}: sets outer (thin) interval (default = 90\%)
 \item \code{point_est}: what point estimate to use (dot), default = \code{"median"}, can also use \code{"mean"} or \code{"none"}
}}
}
\description{
\code{plot_intervals} plots the posterior interval estimates (quantile-based) from the MCMC draws in a MixSIAR model.
Calls \href{http://mc-stan.org/bayesplot/reference/MCMC-intervals.html}{bayesplot::mcmc_intervals}.
}
\examples{
\dontrun{
# 1. run mantis shrimp example
original <- combine_sources(jags.1, mix, source, alpha, 
                groups=list(alphworm="alphworm",brittlestar="brittlestar",clam="clam",
                           crab="crab",fish="fish",snail="snail"))
# 2. combine 6 sources into 2 groups of interest (hard-shelled vs. soft-bodied)
#   'hard' = 'clam' + 'crab' + 'snail'           # group 1 = hard-shelled prey
#   'soft' = 'alphworm' + 'brittlestar' + 'fish' # group 2 = soft-bodied prey
combined <- combine_sources(jags.1, mix, source, alpha.prior=alpha, 
                groups=list(hard=c("clam","crab","snail"), soft=c("alphworm","brittlestar","fish")))

plot_intervals(combined,toplot="fac1")
plot_intervals(original,toplot="fac1")
plot_intervals(combined,toplot="fac1",levels=1)
plot_intervals(combined,toplot="fac1",levels=2)

}
}
\seealso{
\code{\link{combine_sources}} and \code{\link{summary_stat}}
}
