#' NBA data
#'The data set contains four descriptive statistics for all 105 guards for the 1992–1993 season.
#'There are many ways to measure the (statistical) performance of guards in the NBA. Of interest is how the
#'height of the player, minutes per game and free throw percentage affect points per game.
#'Variable description:
#'Height: height of the player
#'MPG: minutes per game
#'FTP: free throw percentage
#'PPM: points per game
#' @name NBA
#' @docType data
#'
#' @references Chatterjee, S., Handcock, M. S., & Simonoff, J. S. (1995). A casebook for a first course in statistics and data analysis (No. 04; QA276. 12, C4.). New York: Wiley.
#' @references Xiang, S., & Yao, W. (2020). Semiparametric mixtures of regressions with single-index for model based clustering. Advances in Data Analysis and Classification, 14(2), 261-292.
#' @keywords data
NULL


#' ROE data
#' contains a total of 2,110 Chinese listed companies on
#' their Return on Equity (ROE), meaning the amount of net income returned
#' as a percentage of shareholders equity, which is an important index to measures
#' a corporation’s profitability. It is also a useful indicator for fundamental
#' analysts to price the value of stocks.
#'Variable description:
#'ROE: Return on Equity
#' @name ROE
#' @docType data
#' @references Huang, M., Wang, S., Wang, H., & Jin, T. (2018). Maximum smoothed likelihood estimation for a class of semiparametric Pareto mixture densities. Statistics and Its Interface, 11(1), 31-40.
#' @keywords data
NULL


#' AFDP data
#' contains the 11 sensor measures
#' aggregated over one hour (by means of average or sum) from a gas
#' turbine located in Turkey’s north western region for the purpose of studying
#' flue gas emissions
#'Variable description:
#' @name AFDP
#' @docType data
#'@references Chang, G. T., & Walther, G. (2007). Clustering with mixtures of log-concave distributions. Computational Statistics & Data Analysis, 51(12), 6242-6251.
#' @keywords data
NULL


#' Elbow data
#' This dataset contains elbow dimension measurements on 507 individuals. The 247 men and 260
#' women were primarily individuals in their twenties and thirties, with a
#' scattering of older men and women, all exercising several hours a week.
#'Variable description:
#'Elbow: elbow diameter, sum of two elbows
#' @name elbow
#' @docType data
#' @references Heinz, G., Peterson, L. J., Johnson, R. W., & Kerk, C. J. (2003). Exploring relationships in body dimensions. Journal of Statistics Education, 11(2)
#' @keywords data
NULL
