% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structuralLearning.R
\name{LearningHC}
\alias{LearningHC}
\title{Learning Hybric Bayesian Networks}
\usage{
LearningHC(dataset, numIntervals = NULL)
}
\arguments{
\item{dataset}{A dataset with discrete and continuous variables. Discrete variables 
must be of class \code{"factor"}, if not they are transformed into factores.}

\item{numIntervals}{A \code{"numeric"} value containing the number of intervals 
to create a discrete dataset. The method used to split the values is by equal width.
By default it is \code{NULL} and means the variables are not discretized to get the network.}
}
\value{
The output is a \code{"bn"} object containing the learned graph.
}
\description{
Get a directed acyclic graph using the method \bold{hill climbing}.
It is a mathematical optimization technique which belongs to the 
family of local search. It is an iterative algorithm which deals with
discrete and continuous variables.
}
\examples{

## Data
data(ecoli)
ecoli <- ecoli[,-1] ## Sequence Name

## DAG1
dag1 <- LearningHC(ecoli)
dag1
plot(dag1)

## DAG2
dag2 <- LearningHC(ecoli, numIntervals = 10)
dag2
plot(dag2)


}
\seealso{
\link{hc}
}
