% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conditional.R
\name{conditionalmotbf.learning}
\alias{conditionalmotbf.learning}
\alias{conditionalMethod}
\alias{conditional}
\alias{select}
\alias{learn.tree.Intervals}
\alias{BICscoreMoTBF}
\title{Learning conditional MoTBF densities}
\usage{
conditionalMethod(
  data,
  nameParents,
  nameChild,
  numIntervals,
  POTENTIAL_TYPE,
  maxParam = NULL,
  s = NULL,
  priorData = NULL
)

conditional(
  data,
  nameParents,
  nameChild,
  domainChild,
  domainParents,
  numIntervals,
  mm,
  POTENTIAL_TYPE,
  maxParam = NULL,
  s = NULL,
  priorData = NULL
)

select(
  data,
  nameParents,
  nameChild,
  domainChild,
  domainParents,
  numIntervals,
  POTENTIAL_TYPE,
  maxParam = NULL,
  s = NULL,
  priorData = NULL
)

learn.tree.Intervals(
  data,
  nameParents,
  nameChild,
  domainParents,
  domainChild,
  numIntervals,
  POTENTIAL_TYPE,
  maxParam = NULL,
  s = NULL,
  priorData = NULL
)

BICscoreMoTBF(conditionalfunction, data, nameParents, nameChild)
}
\arguments{
\item{data}{An object of class \code{"data.frame"}.}

\item{nameParents}{A \code{"character"} vector containing the names of the parent variables.}

\item{nameChild}{A \code{"character"} string containing the name of the child variable.}

\item{numIntervals}{A positive integer indicating the maximum number of intervals 
for splitting the domain of the parent variables.}

\item{POTENTIAL_TYPE}{A \code{"character"} string, either \emph{MOP} or \emph{MTE}, corresponding 
to the type of basis function.}

\item{maxParam}{A positive integer which indicates the maximum number of coefficients in the 
function. If specified, the output is the function which gets the best BIC with, at most, 
this number of parameters. By default, it is set to \code{NULL}.}

\item{s}{A \code{"numeric"} value indicating the expert's confidence in the prior knowledge. 
This argument takes values on the interval \emph{[0, N]}, where \emph{N} is the sample size, and is used
to synchronize the support of the prior knowledge and the sample.
By default, it is \code{NULL}, and must be modified only if prior information is to be 
incorporated in the learning process.}

\item{priorData}{An object of class \code{"data.frame"}, corresponding to the prior information.}

\item{domainChild}{A \code{"numeric"} vector with the range of the child variable.}

\item{domainParents}{An object of class \code{"matrix"} with the range of the parent 
variables, or a \code{"numeric"} vector if there is only one parent.}

\item{mm}{One of the inputs and the output of the recursive internal function \code{"conditional"}.}

\item{conditionalfunction}{The output of the internal function \code{learn.tree.Intervals}.}
}
\value{
The main function \code{conditionalMethod} returns a list with the name of the parents, 
the different intervals and the fitted densities
}
\description{
Collection of functions used for learning conditional MoTBFs,
computing the internal BIC, selecting the parents that get 
the best BIC value, and other internal functions required to learn the
conditional densities.
}
\details{
The main function, \code{conditionalMethod()}, fits truncated basis functions for the conditioned variable 
for each configuration of splits of the parent variables. The domain of the parent variables is splitted
in different intervals and univariate functions are fitted in these 
ranges. The remaining above described functions are internal to the main function.
}
\examples{
## Dataset
X <- rnorm(1000)
Y <- rbeta(1000, shape1 = abs(X)/2, shape2 = abs(X)/2)
Z <- rnorm(1000, mean = Y)
data <- data.frame(X = X, Y = Y, Z = Z)

## Conditional Method
parents <- c("X","Y")
child <- "Z"
intervals <- 2

potential <- "MTE"
fMTE <- conditionalMethod(data, nameParents = parents, nameChild = child, 
numIntervals = intervals, POTENTIAL_TYPE = potential)
printConditional(fMTE)

##############################################################################
\donttest{
potential <- "MOP"
fMOP <- conditionalMethod(data, nameParents = parents, nameChild = child,
numIntervals = intervals, POTENTIAL_TYPE = potential, maxParam = 15)
printConditional(fMOP)
}
##############################################################################

##############################################################################
## Internal functions: Not needed to run #####################################
##############################################################################
\donttest{
domainP <- range(data[,parents])
domainC <- range(data[, child])
t <- conditional(data, nameParents = parents, nameChild = child,
domainParents = domainP, domainChild = domainC, numIntervals = intervals,
mm = NULL, POTENTIAL_TYPE = potential)
printConditional(t)
selection <- select(data, nameParents = parents, nameChild = child,
domainParents = domainP, domainChild = domainC, numIntervals = intervals,
POTENTIAL_TYPE = potential)
parent1 <- selection$parent; parent1
domainParent1 <- range(data[,parent1])
treeParent1 <- learn.tree.Intervals(data, nameParents = parent1,
nameChild = child, domainParents = domainParent1, domainChild = domainC,
numIntervals = intervals, POTENTIAL_TYPE = potential)
BICscoreMoTBF(treeParent1, data, nameParents = parent1, nameChild = child)
}
###############################################################################
###############################################################################
}
\seealso{
\link{printConditional}
}
