context("removeTaxon")

data = read.morphodata("../testFiles/sample.txt")

test_that("remove unexisting taxon",  {
  expect_error(removeTaxon(data, "unexisting"), "Taxon \"unexisting\" does not exist." )
})

test_that("remove one taxon",  {
  subData = removeTaxon(data, "hybr")

  expect_equal(length(levels(data$Taxon)) -1, length(levels(subData$Taxon)))

  expect_equal(dim(data$data)[1] - 120, dim(subData$data)[1])

  expect_equal(paste(subData$data[,1], collapse = " "), "47.2 57.8 61.6 48.3 48.8 59.4 55.7 38.9 55.5 65.5 52.7 61.7 56.5 51.3 57.1 55.8 64.5 53.8 59 61.6 48.8 44.5 45.3 32 59 49.6 49.8 36.2 45 49.8 56.3 57.8 46.4 36.3 46.2 39.1 37.4 34.7 34.8 48.5 43.8 47.4 53.3 59.7 36.6 53.4 44.5 61.9 51.1 44.1 34.7 43.8 62.6 55.5 56.9 58.5 46.7 56.5 58.7 44.1 54.5 52 47.7 59.6 34.4 81.9 65.7 75.1 64.6 77.5 38 55.5 59.3 50.2 67.1 40.1 32.2 67 48.6 58.1 30.7 77.1 35.6 73.1 50 49.4 46.2 59.8 31.9 46.6 82.2 37.6 37.7 48.6 29.5 36.2 83.8 70.5 34.4 35.8 62.6 48.9 60.3 56.7 79.8 54.8 68.2 41.2 75.5 58.6 49.6 70.4 71.4 68.5 68.2 71.1 77.9 57.5 52.4 54.3 84.3 80.5 53.2 65.6 80 72.1 57.3 83.4 112.4 73.8 78.2 69.5 66.8 85.6 89 78.6 85.3 64.6 85 83.3 25.2 28.5 26.1 13 12.6 21.6 17.5 9.2 14.2 23.7 29.7 19.7 31 23.6 9.1 15.6 8.2 9.7 17.3 34.1 53.4 35.1 44.7 76 83.4 71.1 81.3 73.6 72.5 37.5 79.4 52.5 57.2 52 83.5 43.2 51.5 64.2 78.8 53.8 42.7 36.3 43.6 33 27.9 26.6 47.6 27.2 13.3 57 45.3 12.8 25 27.1 38.1 38.2 49 39.1 26.2 45.5 38 51.5 35.7 53.1 61.9 62.6 60.3 53.7 70 59.8 54.4 58.6 37.3 45.9 60.3 58.8 49.1 66.9 57.6 63.7 71.8 67.5 46.5 44.8 53.8 83.2 39.5 77.3 70.1 61.6 71.5 47.3 46 26.7 29.8 33.5 43.4 33.6 35.3 41.1 35.6 46.3 65.7 51.9 39.6 47.8 55.6 57.9 62.6 51.8 68.7 51.3 51.7 41.7 33.9 24 45 39.4 18.7 23.3 65.2 41.1 57.2 26.4 39.2 35.8 41.7 19.9 25 36.3 21.8 33.6 42.7 62.3 81.7 70.2 45.6 61.5 81.5 53 86.8 70.6 73 44.4 97.1 84.3 51.3 104.5 75.4 67.5 74.6 72.3 45.6 43.7 56.8 38.2 71.9 52.1 46 72.5 69.8 57.5 27.4 77.9 41.8 64.7 32.8 65.2 40.5 31.8 48.1 46.8 52 40.5 47.4 65.8 55.8 53.7 29.7 38 48.2 45.3 39 44.1 22.6 61.9 47.2 42.7 28 33.4 54.7 17.5 63.3 44.6 66.5 95.4 40.8 52.8 52.2 45.9 57.2 35.9 60.2 56.5 50.4 53.4 61.7 55.4 75.3 56.6 48.5 68.8 51.8 55.7 53 43.1 51.3 47.6 27.5 88.1 58.4 59.6 60.3 54.3 58.8 41 85.4 62.5 40.9 53.3 77.5 40.7 35 34.9 37.8 37.2 27.1 32.5 70.2 37 37.2 34.3 35.3 40.2 20.4 34.7 20.2 23.9 64.7 30.1 23.6 61.2 42.9 43 21.2 43.1 36 59.3 32.5 62.5 38.4 52.9 22.4 44.8 59.2 22.4 39.6 38.4 33.6 71.1 33 36.8 39.5 49.9 37.4 43.9 23.1 49.6 57.1 44.6 58 51.7 55.3 46 28.6 36.4 38.8 32.5 42.9 37.2 29.1 34.7 40.5 47.6 45 38.1 46.7 48.6 40.1 65 43.4 45.1 61.4 43.4 38.2 31.3 48 67.9 54.7 81.4 53.5 48.8 28.4 107.9 65.8 97.2 69 89.7 72.9 91 41.4 65.1 46.2 63.1 32 62.1 76.2 47.4 41.8 65 41.1 48.9 49.2 68.1 65.7 48.4 69.7 61.5 63.7 29.7 46.2 64.5 96.8 43 43.2 38.4 64.2 31.9 45 64.5 33.9 28.2 33.2 44.6 50.6 20.3 32.1 31.7 35.5 27.6 35.8 38.6 44.7 46.8 26.9 32.8 30.8 35.7 21.7 34.8 35.3 25 28 16.3 31.3 33.6 25.7 39.7 38.5 31.8 36.2 31.3 24.4 31.5 27.1 28.2 30.1 44.4 36.4 28.6 29 41.7")

  expect_output(str(subData), "List of 4")
  expect_is(subData, "morphodata")
})
