% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readCHMD.R
\name{ReadCHMD}
\alias{ReadCHMD}
\title{Download the Canadian Human Mortality Database (CHMD)}
\usage{
ReadCHMD(what, regions = NULL, interval = "1x1", save = FALSE,
  show = TRUE)
}
\arguments{
\item{what}{What type of data are you looking for? The following options are
available: \itemize{
  \item{\code{"births"}} -- birth records;
  \item{\code{"Dx_lexis"}} -- deaths by Lexis triangles;
  \item{\code{"population"}} -- population size;
  \item{\code{"Dx"}} -- death counts;
  \item{\code{"Ex"}} -- exposure-to-risk;
  \item{\code{"mx"}} -- central death-rates;
  \item{\code{"LT_f"}} -- period life tables for females;
  \item{\code{"LT_m"}} -- period life tables for males;
  \item{\code{"LT_t"}} -- period life tables both sexes combined;
  \item{\code{"e0"}} -- period life expectancy at birth;
  }}

\item{regions}{Specify the region specific data you want to download by
adding the CHMD region code/s. Options:
\itemize{
  \item{\code{"CAN"}} -- Canada - Sum of Canadian provinces and territories;
  \item{\code{"NFL"}} -- Newfoundland & Labrador;
  \item{\code{"PEI"}} -- Prince Edward Island;
  \item{\code{"NSC"}} -- Nova Scotia;
  \item{\code{"NBR"}} -- New Brunswick;
  \item{\code{"QUE"}} -- Quebec;
  \item{\code{"ONT"}} -- Ontario;
  \item{\code{"MAN"}} -- Manitoba;
  \item{\code{"SAS"}} -- Saskatchewan;
  \item{\code{"ALB"}} -- Alberta;
  \item{\code{"BCO"}} -- British Columbia;
  \item{\code{"NWT"}} -- Northwest Territories & Nunavut;
  \item{\code{"YUK"}} -- Yukon;
  \item{\code{NULL}} -- if \code{NULL} data for all the regions are downloaded.
  }}

\item{interval}{Datasets are given in various age and time formats based on
which the records are agregated. Interval options:
\itemize{
  \item{\code{"1x1"}} -- by age and year;
  \item{\code{"1x5"}} -- by age and 5-year time interval;
  \item{\code{"1x10"}} -- by age and 10-year time interval;
  \item{\code{"5x1"}} -- by 5-year age group and year;
  \item{\code{"5x5"}} -- by 5-year age group and 5-year time interval;
  \item{\code{"5x10"}} --by 5-year age group and 10-year time interval.
  }}

\item{save}{Do you want to save a copy of the dataset on your local machine?
Logical. Default: \code{FALSE}.}

\item{show}{Choose whether to display a progress bar. Logical.
Default: \code{TRUE}.}
}
\value{
A \code{ReadCHMD} object that contains:
 \item{input}{List with the input values;}
 \item{data}{Data downloaded from CHMD;}
 \item{download.date}{Time stamp;}
 \item{years}{Numerical vector with the years covered in the data;}
 \item{ages}{Numerical vector with ages covered in the data.}
}
\description{
Download detailed mortality and population data for different
provinces and territories in Canada, in a single object from the
\href{http://www.bdlc.umontreal.ca/chmd/index.htm}{
Canadian Human Mortality Database}.
}
\details{
(Description taken from the CHMD website).

The Canadian Human Mortality Database (CHMD) was created to provide detailed
Canadian mortality and population data to researchers, students, journalists,
policy analysts, and others interested in the history of human longevity.
The project is an achievement of the Mortality and Longevity research team at
the Department of Demography, Universite de Montreal, under the supervision
of Professor Robert Bourbeau, in collaboration with demographers at the
Max Plank Institute for Demographic Research (Rostock, Germany) and the
Department of Demography, University of California at Berkeley.
Nadine Ouellette, researcher at the Institut national d'etudes demographiques
in Paris and member of the Mortality and Longevity research team at the
Universite de Montreal, is in charge of computing all CHMD life tables and
updating the CHMD web site.

The CHMD is a "satellite" of the Human Mortality Database (HMD), an
international database which currently holds detailed data flor multiple
countries or regions. Consequently, the CHMD's underlying methodology
corresponds to the one used for the HMD.

The CHMD gathers all required data (deaths counts, births counts, population
size, exposure-to-risk, death rates) to compute life tables for Canada,
its provinces and its territories. One of the great advantages of the
database is to include data that is validated and corrected, when required,
and rendered comparable, if possible, for the period ranging from 1921
thru 2011. For comparison purposes, various life tables published by
governmental organizations are also available for download in PDF format.
}
\examples{
\dontrun{
# Download demographic data for Quebec and Saskatchewan regions in 1x1 format

# Death counts. We don't want to export data outside R.
CHMD_Dx <- ReadCHMD(what = "Dx",
                    regions = c('QUE', 'SAS'),
                    interval  = "1x1",
                    save = FALSE)
ls(CHMD_Dx)
CHMD_Dx

# Download life tables for female population and export data.
LTF <- ReadCHMD(what = "LT_f",
                regions = c('QUE', 'SAS'),
                interval  = "1x1",
                save = TRUE)
LTF
}
}
\seealso{
\code{\link{ReadHMD}}
\code{\link{ReadAHMD}}
}
\author{
Marius D. Pascariu
}
