% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_with_vectorized_parameters.R
\name{f_with_vectorized_parameters}
\alias{f_with_vectorized_parameters}
\title{Use function f to generate the outputs from a ATSM}
\usage{
f_with_vectorized_parameters(
  x,
  sizex,
  f,
  con,
  varargin,
  ModelType,
  FactorLabels,
  Economies,
  JLLinputs,
  GVARinputs,
  nargout
)
}
\arguments{
\item{x}{vector containing all the vectorized auxiliary parameters}

\item{sizex}{matrix (6x2) containing the size information of all parameters}

\item{f}{vector-valued objective function (function)}

\item{con}{if con = 'concentration', then set the value of the parameter whose name
contains @ to empty}

\item{varargin}{variable inputs used in the optimization (see inputs from "optimization" function)}

\item{ModelType}{string-vector containing the label of the model to be estimated}

\item{FactorLabels}{string-list based which contains the labels of all the variables present in the model}

\item{Economies}{string-vector containing the names of the economies which are part of the economic system}

\item{JLLinputs}{Set of necessary inputs used in the estimation of the JLL-based models (see "JLL" function)}

\item{GVARinputs}{Set of necessary inputs used in the estimation of the GVAR-based models (see "GVAR" function)}

\item{nargout}{if nargout <- 1, returns only the values of the likelihood function.\cr
If nargout <- 2, generates the entire set of outputs}
}
\description{
Use function f to generate the outputs from a ATSM
}
\references{
This function is modified version of the "f_with_vectorized_parameters" function by Le and Singleton (2018).\cr
"A Small Package of Matlab Routines for the Estimation of Some Term Structure Models." \cr
(Euro Area Business Cycle Network Training School - Term Structure Modelling).
 Available at: https://cepr.org/40029
}
\keyword{internal}
