% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BiasCorrection.R
\name{Bias_Correc_VAR}
\alias{Bias_Correc_VAR}
\title{Estimate an unbiased VAR(1) using stochastic approximation (Bauer, Rudebusch and Wu, 2012)}
\usage{
Bias_Correc_VAR(
  ModelType,
  BRWinputs,
  RiskFactors,
  N,
  Economies,
  FactorLabels,
  GVARinputs = NULL,
  JLLinputs = NULL,
  ev_restr = 1,
  nargout = 4
)
}
\arguments{
\item{ModelType}{string-vector containing the label of the model to be estimated}

\item{BRWinputs}{List containing the following necessary inputs for the estimation of the BRW model:
\enumerate{
\item flag_mean: flag whether mean- (TRUE) or median- (FALSE) unbiased estimation is desired. Default is set to TRUE;
\item gamma: adjustment parameter. Value parameters should vary between 0 and 1. Default is set to 0.5;
\item N_iter: number of iterations used in the stochatic approximation algorithm after burn-in. Default is set to 5,000;
\item N_burn: number of burn-in iterations used in the stochatic approximation algorithm. Default is set to 0.15*N_iter;
\item B: number of bootstrap samples per iteration to calculate noisy measure of mean/median of the OLS estimator.
       Default is set to 50;
\item check: flag whether the user wishes to perform the closeness check. Default is set to TRUE;
\item B_check: number of bootstrap samples used in the closeness check. Default is set to 100,000.
}}

\item{RiskFactors}{time series of the risk factors (T x F)}

\item{N}{number of country-specific spanned factors (scalar)}

\item{Economies}{string-vector containing the names of the economies which are part of the economic system}

\item{FactorLabels}{string-list based which contains the labels of all variables present in the model}

\item{GVARinputs}{inputs used in the estimation of the GVAR-based models (see "GVAR" function). Default is set to NULL}

\item{JLLinputs}{inputs used in the estimation of the JLL-based models (see "JLL" function). Default is set to NULL}

\item{ev_restr}{largest eigenvalue restriction under the P-measure. Default is set to 1}

\item{nargout}{number of elements present in the list of outputs. Default is set to 4}
}
\value{
Bias-corrected VAR paramaters based on the framework of Bauer, Rudebusch and Wu (2012). The list contains:
\enumerate{
\item Phi_tilde estimated coefficient matrix (F x F);
\item mu_tilde: estimated intercept (F x 1);
\item V_tilde: estimated variance-covariance matrix (F x F);
\item dist: root mean square distance (scalar);
\item Phi_sample: sample estimated variance-covariance matrix used in the checks (F x F x B_check) - this output is
     reported if nargout is set to 5.
}
}
\description{
Estimate an unbiased VAR(1) using stochastic approximation (Bauer, Rudebusch and Wu, 2012)
}
\examples{
\donttest{
data(CM_Factors)
Factors <- t(RiskFactors[1:7,])

BRWinputs <- list()
BRWinputs$flag_mean <- TRUE
BRWinputs$gamma <- 0.4
BRWinputs$N_iter <- 1000
BRWinputs$N_burn <- 100
BRWinputs$B <- 10
BRWinputs$check <- 1
BRWinputs$B_check <- 5000

Economies <- "China"
N <- 3
ModelType <- "JPS"
FactorLabels <- NULL


BRWpara <- Bias_Correc_VAR(ModelType, BRWinputs, Factors, N, Economies, FactorLabels)
}

}
\references{
Bauer, Rudebusch and, Wu (2012). "Correcting Estimation Bias in Dynamic Term Structure Models" \cr
This function is based on the "est_unb_var" Matlab function available at Cynthia Wu's website
(https://sites.google.com/view/jingcynthiawu/).
}
