% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Commutators.R
\name{matr_Elimination}
\alias{matr_Elimination}
\title{Elimination Matrix}
\usage{
matr_Elimination(d, q, useSparse = FALSE)
}
\arguments{
\item{d}{dimension of a vector x}

\item{q}{power of the Kronecker product}

\item{useSparse}{TRUE or FALSE.}
}
\value{
Elimination matrix of order \eqn{\eta_{d,q} \times d^q= {d+q-1 \choose q}}.
If \code{useSparse=TRUE} an object of the class "dgCMatrix" is produced.
}
\description{
Eliminates the duplicated/q-plicated elements  in a T-vector of multivariate moments
and cumulants.
}
\examples{
x<-c(1,2,3)
y<-kronecker(kronecker(x,x),x)
## Distinct elements of y
z<-as.matrix(matr_Elimination(3,3))\%*\%y
## Restore eliminated elements in z
as.vector(matr_Qplication(3,3)\%*\%z)

}
\references{
Gy. Terdik, Multivariate statistical methods - going beyond the linear,
Springer 2021.  Section  1.3.2 Multi-Indexing, Elimination, and Duplication, p.21,(1.32)
}
\seealso{
Other Matrices and commutators: 
\code{\link{indx_Commutator_Kmn}()},
\code{\link{indx_Commutator_Kperm}()},
\code{\link{indx_Elimination}()},
\code{\link{indx_Qplication}()},
\code{\link{indx_Symmetry}()},
\code{\link{indx_UnivMomCum}()},
\code{\link{matr_Commutator_Kmn}()},
\code{\link{matr_Commutator_Kperm}()},
\code{\link{matr_Commutator_Mixing}()},
\code{\link{matr_Commutator_Moment}()},
\code{\link{matr_Qplication}()},
\code{\link{matr_Symmetry}()}
}
\concept{Matrices and commutators}
