% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Commutators.R
\name{matr_Commutator_Kmn}
\alias{matr_Commutator_Kmn}
\title{Commutation matrix}
\usage{
matr_Commutator_Kmn(m, n, useSparse = FALSE)
}
\arguments{
\item{m}{Row-dimension}

\item{n}{Col-dimension}

\item{useSparse}{T or F.}
}
\value{
A commutation matrix matrix of dimension \eqn{mn \times mn}. If \code{useSparse=TRUE} an object of the class
"dgCMatrix" is produced.
}
\description{
Transforms vec A to vec of the transposed A. An option for sparse matrix is provided, by default a
non-sparse matrix is produced. Using sparse matrices increases computation times, but far
less memory is required
}
\examples{
A<-matrix(1:6,3,2)
as.vector(matr_Commutator_Kmn(3,2)\%*\%c(A))
}
\references{
Gy. Terdik, Multivariate statistical methods - Going beyond the linear,
Springer 2021 (p.8, (1.12)).
}
\seealso{
Other Matrices and commutators: 
\code{\link{indx_Commutator_Kmn}()},
\code{\link{indx_Commutator_Kperm}()},
\code{\link{indx_Commutator_Mixing}()},
\code{\link{indx_Commutator_Moment}()},
\code{\link{indx_Elimination}()},
\code{\link{indx_Qplication}()},
\code{\link{indx_Symmetry}()},
\code{\link{indx_UnivMomCum}()},
\code{\link{matr_Commutator_Kperm}()},
\code{\link{matr_Commutator_Mixing}()},
\code{\link{matr_Commutator_Moment}()},
\code{\link{matr_Elimination}()},
\code{\link{matr_Qplication}()},
\code{\link{matr_Symmetry}()}
}
\concept{Matrices and commutators}
