% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Hermite.r
\name{Hermite_Nth}
\alias{Hermite_Nth}
\title{T-Hermite polynomial with order N at standardized vector x}
\usage{
Hermite_Nth(x, N)
}
\arguments{
\item{x}{multivariate data of size d}

\item{N}{degree of T-Hermite polynomial}
}
\value{
d-variate T-Hermite polynomial of order N evaluated at vector x
}
\description{
Computes the N-th d-variate T-Hermite polynomial at standardized vector x
}
\references{
Gy.Terdik, Multivariate statistical methods - going beyond the linear,
Springer 2021.  Section 4.6.2, (4.73), p.223
}
\seealso{
Other Hermite: 
\code{\link{Hermite_CoeffMulti}()},
\code{\link{Hermite_Coeff}()},
\code{\link{Hermite_N_Cov_X1_X2}()},
\code{\link{Hermite_Poly_HN_Multi}()},
\code{\link{Hermite_Poly_HN}()},
\code{\link{Hermite_Poly_NH_Inv}()},
\code{\link{Hermite_Poly_NH_Multi_Inv}()}
}
\concept{Hermite}
