% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BPI.R
\name{BPI}
\alias{BPI}
\title{Calculates Bathymetric Position Index}
\usage{
BPI(
  r,
  radius = NULL,
  unit = "cell",
  w = NULL,
  na.rm = FALSE,
  include_scale = FALSE,
  filename = NULL,
  overwrite = FALSE,
  wopt = list()
)
}
\arguments{
\item{r}{DTM as a SpatRaster or RasterLayer}

\item{radius}{a vector of length 2 specifying the inner and outer radii of the annulus c(inner,outer). This is ignored if w is provided.}

\item{unit}{unit for radius. Either "cell" (number of cells, the default) or "map" for map units (e.g. meters). This is ignored if w is provided.}

\item{w}{A focal weights matrix specifying which cells to include and exclude in the annulus focal window which can be created using MultiscaleDTM::annulus_window.}

\item{na.rm}{A logical vector indicating whether or not to remove NA values before calculations}

\item{include_scale}{logical indicating whether to append window size to the layer names (default = FALSE). If unit="map" then window size will have "MU" after the number indicating that the number represents the window size in map units.}

\item{filename}{character Output filename.}

\item{overwrite}{logical. If TRUE, filename is overwritten (default is FALSE).}

\item{wopt}{list with named options for writing files as in writeRaster}
}
\value{
a SpatRaster or RasterLayer
}
\description{
Calculates Bathymetric Position Index (BPI). This is the value of the focal pixel minus the mean of the surrounding pixels contained within an annulus shaped window.
}
\examples{
r<- rast(volcano, extent= ext(2667400, 2667400 + 
ncol(volcano)*10, 6478700, 6478700 + nrow(volcano)*10), 
crs = "EPSG:27200")
bpi<- BPI(r, radius = c(2,4), unit = "cell", na.rm = TRUE)
plot(bpi)
}
\references{
Lundblad, E.R., Wright, D.J., Miller, J., Larkin, E.M., Rinehart, R., Naar, D.F., Donahue, B.T., Anderson, S.M., Battista, T., 2006. A benthic terrain classification scheme for American Samoa. Marine Geodesy 29, 89–111. https://doi.org/10.1080/01490410600738021
}
