% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_fourth_down_strategy.R
\name{sample_fourth_down_strategy}
\alias{sample_fourth_down_strategy}
\title{Sample NFL play-by-play data with a specified 4th down strategy}
\usage{
sample_fourth_down_strategy(
  what_down,
  yards_to_go,
  yards_from_own_goal,
  window_yards_from_own_goal = 1,
  play_by_play_data,
  fourth_down_strategy = "empirical",
  yards_less_than = 5
)
}
\arguments{
\item{what_down}{The current down (1st, 2nd, 3rd, or 4th down)}

\item{yards_to_go}{Number of yards to go until a first down or TD}

\item{yards_from_own_goal}{The number of yards from the possession team's own goal}

\item{window_yards_from_own_goal}{Precision parameter for "yards_from_own_goal" (a value of 1 means the sampling
will occur within plus or minus 1 of the "yards_from_own_goal" value)}

\item{play_by_play_data}{A data file from nflscrapR prepped using the prep_pbp_data.R function}

\item{fourth_down_strategy}{The specific fourth down strategy `empirical`, `always_go_for_it`, `never_go_for_it`,`yds_less_than`,`exp_pts`}

\item{yards_less_than}{Parameter for `yds_less_than` strategy. If using `yds_less_than` strategy and one is less than `yards_less_than` yards from first down/touchdown, then go for it on fourth down}
}
\value{
A tibble containing lots of info
}
\description{
This function will return a sample play from the nflscrapR play-by-play
data for a given down, distance, yards from the team's goal, using
a given strategy on fourth down. The strategies are: empirical, always 
going for it on fourth down, never going for it on fourth down, go for it 
if one is less than a certain distance from a first down/touchdown,
and go for it if it maximizes one's expected points. This should be primarily
used within the `NFLSimulatoR::sample_play()` function.
}
\examples{
\dontrun{
sample_fourth_down_strategy(what_down = 3,
                      yards_to_go = 2,
                      yards_from_own_goal = 45,
                      window_yards_from_own_goal = 2,
                      play_by_play_data = reg_pbp_2018,
                      fourth_down_strategy = "empirical")
}
}
