## -*- truncate-lines: t; -*-

test.minvar <- function() {

    var <- structure(c(0.000988087100677907, -0.0000179669410403153, 0.000368923882626859, 
                       0.000208303611101873, 0.000262742052359594, -0.0000179669410403153, 
                       0.00171852167358765, 0.0000857467457561209, 0.0000215059246610556, 
                       0.0000283532159921211, 0.000368923882626859, 0.0000857467457561209, 
                       0.00075871953281751, 0.000194002299424151, 0.000188824454515841, 
                       0.000208303611101873, 0.0000215059246610556, 0.000194002299424151, 
                       0.000265780633005374, 0.000132611196599808, 0.000262742052359594, 
                       0.0000283532159921211, 0.000188824454515841, 0.000132611196599808, 
                       0.00025948420130626),
                     .Dim = c(5L, 5L),
                     .Dimnames = list(c("CBK.DE", "VOW.DE", "CON.DE", "LIN.DE", "MUV2.DE"),
                                      c("CBK.DE", "VOW.DE", "CON.DE", "LIN.DE", "MUV2.DE")))
    

    res <- minvar(var, wmin = 0, wmax = 0.25)
    checkTrue(all(res >= 0))
    checkTrue(all(res <= 0.25))
    checkEqualsNumeric(sum(res), 1)
    checkEqualsNumeric(attr(res, "variance"),
                       res %*% var %*% res)
    
}

