% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covariate-explore.R
\name{cov_cov_plot}
\alias{cov_cov_plot}
\title{Plot correlation between two covariates}
\usage{
cov_cov_plot(
  d,
  cov,
  continuous,
  log_transform_plot = rep(FALSE, length(cov)),
  dcov_info,
  by = "ID"
)
}
\arguments{
\item{d}{Dataset with covariates.}

\item{cov}{Vector of length 2 for covariate names.}

\item{continuous}{Logical vector of length 2 for whether cov is continuous or
not.}

\item{log_transform_plot}{Should plot be log transformed or not.}

\item{dcov_info}{Optional \code{data.frame} with covariate information.}

\item{by}{Character (default = \code{"ID"}) variable to split over.}
}
\value{
\code{ggplot2} object displaying covariate-covariate correlations.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Useful for exploratory plots.
}
