% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic-ctl-manipulation.R
\name{dollar}
\alias{dollar}
\title{Get/set existing subroutine}
\usage{
dollar(m, dollar, ..., add_dollar_text = TRUE)
}
\arguments{
\item{m}{An nm object.}

\item{dollar}{Character. Name of NONMEM subroutine to target.}

\item{...}{Additional arguments to be passed to \code{text()}.  If specified these
will set the contents of the subroutine.  See examples below.}

\item{add_dollar_text}{Logical (default = \code{TRUE}). Should the $XXXX string be
added to text.}
}
\value{
If \code{dollar} is specified returns the relevant subroutine of the
control file as a character.  Otherwise returns an nm object with modified
\code{ctl_contents} field.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

The fast way to see the contents of a particular subroutine directly in the R
console. It can also be used to set the contents of a NONMEM subroutine in
place of manual edits
}
\examples{

# create example object m1 from package demo files
exdir <- system.file("extdata", "examples", "theopp", package = "NMproject")
m1 <- new_nm(run_id = "m1", 
             based_on = file.path(exdir, "Models", "ADVAN2.mod"),
             data_path = file.path(exdir, "SourceData", "THEOPP.csv"))

m1 \%>\% dollar("PK") ## displays existing $PK

m1 \%>\% dollar("THETA")

c(m1, m1) \%>\% dollar("THETA") # display $THETAs for multiple NONMEM runs

}
\seealso{
\code{\link[=insert_dollar]{insert_dollar()}}, \code{\link[=delete_dollar]{delete_dollar()}}
}
