% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forestSummarize.R
\name{forestSummarize}
\alias{forestSummarize}
\title{Summarize simulated exposures relative to reference subject}
\usage{
forestSummarize(data, funs.exposure, cover.ci = 0.95, by, as.fun)
}
\arguments{
\item{data}{Simulated data to process. This data.frame must
contain must contain multiple columns, as defined by
NMsim::expandCovs().}

\item{funs.exposure}{A named list of functions to apply for
derivation of exposure metrics.}

\item{cover.ci}{The coverage of the confidence intervals. Default
is 0.95.}

\item{by}{a character vector of column names to perform all
calculations by. This could be sampling subsets or analyte.}

\item{as.fun}{The default is to return data as a
`data.frame`. Pass a function (say `tibble::as_tibble`) in
as.fun to convert to something else. If data.tables are
wanted, use `as.fun="data.table"`. The default can be
configured using `NMdataConf()`.}
}
\value{
A data.frame
}
\description{
Summarize simulated exposures relative to reference subject
}
\details{
This function is part of the workflow provided by NMsim
    to generate forest plots - a graphical representation of the
    estimated covariate effects and the uncertainty of those
    effect estimates. `expandCovs()` helps construct a set of
    simulations to perform, simulation methods like `NMsim_VarCov`
    and `NMsim_NWPRI` can perform siulations with parameter
    uncertainty, and `forestSummarize()` can then summarize those
    simulation results into the numbers to plot in a forest
    plot. See the NMsim vignette on forest plot generation
    available on the NMsim website for a step-by-step
    demonstration.

The following columns
    are generated by `expandCovs()` and are expected to be
    present. Differences within any of them will lead to separate
    summarizing (say for as covariate value to be plotted):

\itemize{
\item `model`: A model identifier - generated by `NMsim()`.
\item `type`: The simulation type. "ref" for reference subject, "value" for any other. This is generated by `expandCovs()`.
\item `covvar`: The covariate (of interest) that is different from the reference value in the specific simulation. Example: "WT"
\item `covlabel`: Label of the covariate of interest. Example: "Bodyweight (kg)"
\item `covref`: Reference value of the covariate of interest. Example: 80
\item `covval`: Value of the covariate of interest (not reference). Example 110.
}
}
