% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_sector_info.R
\name{get_sector_info}
\alias{get_sector_info}
\title{Detailed Information about All Main Sectors}
\usage{
get_sector_info(try = FALSE, timeout = Inf)
}
\arguments{
\item{try}{logical: Should the body of the function be wrapped by the function \code{\link[base]{try}}? See details.}

\item{timeout}{positive numeric or \code{Inf}: The number of seconds to wait for a response from the NSO server. Can not be less than 1 ms or 0.001 s.}
}
\value{
A data frame which has sector information if the function is executed without error, but an object of class "try-error" containing the error message, if it fails. The data frame has following structure:
\describe{
 \item{rownum}{Row number}
 \item{list_id}{Sector identification number}
 \item{up_list_id}{Sub sector identification number}
 \item{list_nm}{Sector name in Mongolian}
 \item{list_eng_nm}{Sector name in English}
 \item{isExist}{Whether or exist sub-sectors}
}
}
\description{
Detailed information about all main sectors, which are major classification of data, on the open-data API which is supported by National Statistical Office of Mongolia (NSO)
}
\details{
The NSO server returns "HTTP error 500" frequently. Due to the server error, error handling is supported. if \code{try} is \code{TRUE}, you have to write code with error handling as shown in the example.
}
\examples{
sector_info <- get_sector_info(try = TRUE, timeout = 4)
if (!inherits(sector_info, "try-error")) {
  print(sector_info)
}
}
\references{
\url{http://opendata.1212.mn/en/doc/Api/GET-api-Sector}
}
\seealso{
\link{all_tables}, \link{get_table}, \link{get_table_info}, \link{get_subsector_info}
}
