% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TAR.r
\name{rcAR}
\alias{rcAR}
\title{Estimating of Random-Coefficient AR Models}
\usage{
rcAR(x, lags = c(1), include.mean = TRUE)
}
\arguments{
\item{x}{a time series of data.}

\item{lags}{the lag of AR models. This is more flexible than using order. It can skip unnecessary lags.}

\item{include.mean}{a logical value indicating whether the constant terms are included.}
}
\value{
\code{rcAR} function returns a list with following components:
\item{par}{estimated parameters.}
\item{se.est}{standard errors.}
\item{residuals}{residuals.}
\item{sresiduals}{standardized residuals.}
}
\description{
Estimate random-coefficient AR models.
}
\examples{
t=50
x=rnorm(t)
phi1=matrix(0.4,t,1)
for (i in 2:t){
   phi1[i]=0.7*phi1[i-1]+rnorm(1,0,0.1)
	x[i]=phi1[i]*x[i-1]+rnorm(1)
}
est=rcAR(x,1,FALSE)
}
