% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/turtle-functions.R
\name{right}
\alias{right}
\alias{right,agentMatrix,numeric-method}
\title{Rotate to the right}
\usage{
right(turtles, angle)

\S4method{right}{agentMatrix,numeric}(turtles, angle)
}
\arguments{
\item{turtles}{\code{AgentMatrix} object representing the moving \code{agents}.}

\item{angle}{Numeric. Vector of angles in degrees by which to rotate the \code{turtles}'
headings. Must be of length 1 or of length \code{turtles}.}
}
\value{
\code{AgentMatrix} representing the \code{turtles} with updated \code{heading} values.
}
\description{
Rotate the \code{turtles}'s headings to the right of \code{angle} degrees.
}
\details{
If a given \code{angle} value is negative, then the turtle rotates to the left.
}
\examples{
w1 <- createWorld(minPxcor = 0, maxPxcor = 4, minPycor = 0, maxPycor = 4)
t1 <- createTurtles(n = 10, world = w1)
of(agents = t1, var = "heading")
t1 <- right(turtles = t1, angle = 180)
of(agents = t1, var = "heading")


}
\references{
Wilensky, U. 1999. NetLogo. http://ccl.northwestern.edu/netlogo/.
            Center for Connected Learning and Computer-Based Modeling,
            Northwestern University. Evanston, IL.
}
\seealso{
\url{https://ccl.northwestern.edu/netlogo/docs/dictionary.html#right}
}
\author{
Sarah Bauduin
}
