% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/communicability_measures.R
\name{communicability_matrix}
\alias{communicability_matrix}
\title{Computes the communicability matrix}
\usage{
communicability_matrix(x, terms = Inf, sparse = TRUE)
}
\arguments{
\item{x}{a square \code{\link{matrix}} or an \code{\link[igraph]{igraph}} object.}

\item{terms}{truncates the communicability matrix evaluation up to a pre-defined number of terms.
If \code{terms = Inf} the function computes the matrix exponential using \code{\link{expm}}.}

\item{sparse}{should the function use sparse matrices when computing the communicability? 
However, if \code{terms = Inf}
the function will use \code{\link{expm}} which uses \code{\link{dgeMatrix-class}}.}
}
\value{
The function returns the communicability matrix.
}
\description{
The communicability of an adjacency matrix M is defined as exp(M) where
M[i,j] can be interpreted as the weighted sums of paths from i to j. 
Recall that exp(M) can be cast into a Taylor series expansion with an 
infinite number additive terms. 
The function permits the evaluation of exp(M) using the \code{\link{expm}} package 
or using a simpler mathematical approximation. 
In the second case, the function truncates the infinite series by 
simply calculating the summation terms up to a pre-defined number of factors.
}
\examples{
# Creating example data
## Assets Matrix (bilateral exposures)
assets_matrix <- matrix(c(0, 10, 3, 1, 0, 2, 0, 3, 0), ncol = 3)
rownames(assets_matrix) <- colnames(assets_matrix) <- letters[1:3]

## Capital Buffer
buffer <- c(a = 2, b = 5, c = 2)

# Computing vulnerability
v <- vulnerability_matrix(assets_matrix, buffer, binary = TRUE)

# Computing communicability of the vulnerability matrix
communicability_matrix(v)

}
\references{
Estrada, E. Hatano, N. (2008). Communicability in complex networks.
Physical Review E, 77:036111.
}
