% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subnet.R
\name{subnet}
\alias{subnet}
\title{Subnetwork from a network}
\usage{
subnet(net, nodes, impl = "auto", neighbors = F, delete = T)
}
\arguments{
\item{net}{The original net, which should be a graph object}

\item{nodes}{Gene symbol, which should match the nodes in original net}

\item{impl}{Character scalar, to choose between two implementation of the subgraph calculation. Details are implemented in subraph function of igraph package}

\item{neighbors}{Logical scalar, whether to get the neighbors of input nodes}

\item{delete}{Logical scalar, whether to remove the nodes which do not have any neighbors in the output network}
}
\value{
A new igraph graph object
}
\description{
subnet generates a subnetwork from a network,which consists of specified nodes
}
\details{
subnet(net,nodes,impl="auto",neighbors=F,delete=T)
}
\examples{
 

NOR2ADE.net <-subnet(net=databases.net,nodes = NOR2ADE.DEGs)

}
