% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkToolbox--master.R
\name{bootgen}
\alias{bootgen}
\title{Bootstrapped Network Generalization}
\usage{
bootgen(data, method = c("MaST", "TMFG", "LoGo", "threshold"), alpha = 0.05,
  n = nrow(data), iter = 1000, normal = FALSE, na.data = c("pairwise",
  "listwise", "fiml", "none"), cores, progBar = TRUE, ...)
}
\arguments{
\item{data}{A set of data}

\item{method}{A network filtering method.
Defaults to "TMFG"}

\item{alpha}{Alpha threshold bootstrapped network generalization network}

\item{n}{Number of people to use in the bootstrap.
Defaults to full sample size}

\item{iter}{Number of bootstrap iterations.
Defaults to 1000 iterations}

\item{normal}{Should data be transformed to a normal distribution?
Defaults to FALSE.
Data is not transformed to be normal.
Set to TRUE if data should be transformed to be normal
(computes correlations using the \link[qgraph]{cor_auto} function)}

\item{na.data}{How should missing data be handled?
For "listwise" deletion the \code{\link{na.omit}} function is applied.
Set to "fiml" for Full Information Maxmimum Likelihood (\link[psych]{corFiml}).
Full Information Maxmimum Likelihood is \strong{recommended} but time consuming}

\item{cores}{Number of computer processing cores to use for bootstrapping samples.
Defaults to \emph{n} - 1 total number of cores.
Set to any number between 1 and maxmimum amount of cores on your computer}

\item{progBar}{Should progress bar be displayed?
Defaults to TRUE.
Set to FALSE for no progress bar}

\item{...}{Additional arguments for filtering methods}
}
\value{
Returns a list that includes the original filtered network (orignet),
correlation matrix of the mean bootstrapped network (bootmat),
and unfiltered reliabilities of all of the connections (netrel)
}
\description{
Bootstraps the sample to identify the most stable correlations.
Also produces a network that is penalizes low reliability edges.
This function is useful for overcoming the structural constraint of the IFN approach
}
\examples{
\dontrun{
bootTMFG<-bootgen(neoOpen)

bootLoGo<-bootgen(neoOpen,method="LoGo")

bootMaST<-bootgen(neoOpen,method="MaST")

bootThreshold<-bootgen(neoOpen,method="threshold")
}
}
\references{
Perez, M. E., & Pericchi, L. R. (2014).
Changing statistical significance with the amount of information: The adaptive \emph{a} significance level.
\emph{Statistics & Probability Letters}, \emph{85}, 20-24.

Tumminello, M., Coronnello, C., Lillo, F., Micciche, S., & Mantegna, R. N. (2007).
Spanning trees and bootstrap reliability estimation in correlation-based networks.
\emph{International Journal of Bifurcation and Chaos}, \emph{17}(7), 2319-2329.
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
