% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comm.str.R
\name{comm.str}
\alias{comm.str}
\title{Community Strength/Degree Centrality}
\usage{
comm.str(A, comm, weighted = TRUE, measure = c("within", "between"))
}
\arguments{
\item{A}{An adjacency matrix of network data}

\item{comm}{A vector corresponding to the
community each node belongs to}

\item{weighted}{Is the network weighted?
Defaults to \code{TRUE}.
Set to \code{FALSE} for weighted measures}

\item{measure}{Type of measure to compute:

\itemize{

\item{\code{"within"}}
{Computes the community strength or degree of nodes within
its own community}

\item{\code{"between"}}
{Computes the community strength or degree of nodes outside
of its own community}

}}
}
\value{
A vector of community strength/degree centrality values for each specified
community in the network
(larger values suggest more central positioning)
}
\description{
Computes the community
\code{\link[NetworkToolbox]{strength}}/\code{\link[NetworkToolbox]{degree}}
centrality measure of each community in a network \code{} or computes the
\code{\link[NetworkToolbox]{strength}}/\code{\link[NetworkToolbox]{degree}}
centrality measure of each community's connections to the other communities
}
\examples{
# Pearson's correlation only for CRAN checks
A <- TMFG(neoOpen, normal = FALSE)$A

comm <- igraph::walktrap.community(convert2igraph(abs(A)))$membership

#Strength
within.ns <- comm.str(A, comm, measure = "within")
between.ns <- comm.str(A, comm, measure = "between")

#Degree
within.deg <- comm.str(A, comm, weighted = FALSE, measure = "within")
between.deg <- comm.str(A, comm, weighted = FALSE, measure = "between")

}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
