% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NeuroDecodeR.R
\docType{package}
\name{NeuroDecodeR}
\alias{NeuroDecodeR}
\title{NeuroDecodeR: A package for neural decoding analyses}
\description{
The NeuroDecodeR makes it easy to do neural decoding analyses in R!
}
\details{
The NeuroDecodeR (NDR) is built around five abstract object types that work
together in a modular way to allow a range of neural decoding analyses. These
five object types are:
\enumerate{
\item Datasources (DS): Generate training and test splits of the data.
\item Feature preprocessors (FP): Learn parameters on the training set and apply
transformations to the training and test sets.
\item Classifiers (CL): Learn the relationship between experimental conditions
(i.e., "labels") and neural data on a training set, and then predict
experimental conditions from neural data in a test set.
\item Result metrics (RM): Aggregate results across validation splits and
over resampled runs and compute and plot final decoding accuracy metrics.
\item Cross-validators (CV): Take the DS, FP, CL and RM objects and run a
cross-validation decoding procedure.
}
}
\section{Data formats}{
Two data formats are used to do decoding analyses which are:
\enumerate{
\item \verb{raster format} contains high temporal precision data where neural
activity from each site is stored in a separate file.
\item \verb{binned format} contains data from multiple sites where the data is more
coarsely binned across time.
}

A user of the NDR will typically store their data in \verb{raster format} and
then use the \code{\link[=create_binned_data]{create_binned_data()}} to create a \verb{binned format} data file
that will be used in the decoding analysis.
}

\keyword{internal}
