% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hierarchical_clusters.R
\name{hierarchical_clusters}
\alias{hierarchical_clusters}
\title{Hierarchical Clusters}
\usage{
hierarchical_clusters(data, Kcluster, distHierarchical)
}
\arguments{
\item{data}{A data frame with four columns:\cr
Initial Latitude | Initial Longitude | Final Latitude | Final Longitude}

\item{Kcluster}{An ODMeans structure, result of function dinamic_clusters.}

\item{distHierarchical}{Maximum distance to create a new hierarchy per cluster.}
}
\value{
Hierarchical Clusters returns an object similar of class "kmeans". It is a list with at least the following components:

cluster A vector of integers (from 1:k) indicating the cluster to which each point is allocated.
centers A matrix of cluster centres.
totss The total sum of squares.
withinss Vector of within-cluster sum of squares, one component per cluster.
tot.withinss Total within-cluster sum of squares, i.e. sum(withinss).
betweenss The between-cluster sum of squares, i.e. totss-tot.withinss.
size The number of points in each cluster.
level_hierarchy Corresponds of the hierarchy level of the cluster, can be "Global" or "Local"
}
\description{
Hierarchical Clusters
}
\examples{
data(ODMeansSampleData)
hierarchical_clusters(ODMeansSampleData, dinamic_clusters(ODMeansSampleData, 5, 200, 2500), 500)
}
