% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.OEFPIL.R
\name{plot.OEFPIL}
\alias{plot.OEFPIL}
\title{Plot the estimate from an OEPFIL object}
\usage{
\method{plot}{OEFPIL}(x, xx, signif.level, interval, new.obs.variance, ...)
}
\arguments{
\item{x}{an object of class \code{"OEFPIL"} (a result of a call to \code{\link{OEFPIL}}).}

\item{xx}{a sequence of x-coordinates of points for computing and plotting confidence bands. If missing, the default sequence \code{seq(from = min(x), to = max(x), length.out = 301)} is used.}

\item{signif.level}{a numerical value or a vector of significance levels for confidence bands.}

\item{interval}{a character vector. It states type of an interval to draw. Following values are possible: \code{"conf"} for confidence interval, \code{"pred"} for prediction interval or \code{c("conf", "pred")} for both. If missing, no intervals are plotted.}

\item{new.obs.variance}{the variance of a new observation for prediction interval computing (see \code{\link{confBands.OEFPIL}}).}

\item{...}{additional arguments (same as in \link{plot} function) affecting the plot.}
}
\value{
Returns an object of type list containing at least the following components

\item{xx}{a numerical vector of points where bands are calculated.}
\item{yy}{a numerical vector with values of estimated function in \code{xx}.}
\item{PointwiseCB}{a matrix of confidence intervals at points \code{xx}.}
\item{PredictCB}{a matrix of prediction intervals at points \code{xx}.}
}
\description{
Plot of the iterated linearization estimate of a function from an \code{"OEFPIL"} object with pointwise confidence and prediction bands.
}
\details{
If the \code{signif.level} argument is missing, even though an \code{interval} argument is set to \code{"conf"}, the default value 0.05 is used.
         The line type is set to \code{'dashed'} for confidence bands and \code{'dotted'} for prediction bands.
         The confidence and prediction bands are computed under normality assumption. If the vector \code{signif.level} length is greater than 1,
         then multiple bands are plotted. The widest band has colour no. 2. The second widest band has colour no. 3 etc.
}
\examples{
library(MASS)

##Use of plot function with default parameters
##(only estimation of the function is plotted, without confidence or prediction bands)
steamdata <- steam
colnames(steamdata) <- c("x","y")
n <- nrow(steamdata)
CM1 <- diag(rep(10,2*n))
st1 <- OEFPIL(steamdata, y ~ b1 * 10^(b2 * x/ (b3 + x)), list(b1 = 5, b2 = 8, b3 = 200),
             CM1, useNLS = FALSE)
plot(st1)

##Use of plot function for plotting confidence bands
plot(st1, seq(0,113,0.1), signif.level = c(0.01,0.05), interval = "conf",
 main = "Graph of estimated function")

##Use of plot function for plotting prediction bands
plot(st1, seq(0,113,0.1), interval = "pred", new.obs.variance = 15)

##Return values of plot function
(a <- plot(st1, signif.level = 0.05, interval = "conf"))

}
\seealso{
\code{\link{OEFPIL}}
}
