% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Testfunctions.R
\name{Test functions}
\alias{Test functions}
\alias{guirland}
\alias{sin1}
\alias{sin1}
\alias{difficult}
\alias{difficult2}
\alias{double_sine}
\title{Test functions of \code{x}}
\usage{
guirland(x)

sin1(x)

difficult(x)

difficult2(x)

double_sine(x, rho1 = 0.3, rho2 = 0.8, tmax = 0.5)
}
\arguments{
\item{x}{vector specifying the location where the function is to be evaluated.}

\item{rho1, rho2, tmax}{additional parameters for double_sine.}
}
\description{
Several test functions of varying complexity are available. They are defined on [0,1].
}
\details{
These test functions are translated from the Matlab and Python codes in the references.
}
\examples{
par(mfrow = c(2,3))

curve(guirland, n = 501)
curve(sin1)
curve(difficult, xlim = c(1e-8, 1), n = 1001)
xgrid <- seq(0, 1, length.out = 500)
plot(xgrid, sapply(xgrid, difficult2), type = 'l', ylab = "difficult2(x)")
plot(xgrid, sapply(xgrid, double_sine), type = 'l', ylab = "double_sine(x) (default)")
double_sine2 <- function(x) double_sine(x, rho1 = 0.8, rho2 = 0.3)
plot(xgrid, sapply(xgrid, double_sine2), type = 'l', ylab = "double_sine(x) (modified)")

par(mfrow = c(1,1))
}
\references{
M. Valko, A. Carpentier and R. Munos (2013), Stochastic Simultaneous Optimistic Optimization,
\emph{ICML}, 19-27 \url{http://hal.inria.fr/hal-00789606}. Matlab code: \url{https://team.inria.fr/sequel/software/StoSOO}. \cr \cr
J.-B. Grill, M. Valko and R. Munos (2015), Black-box optimization of noisy functions with unknown smoothness,
  \emph{NIPS}, 667-675 \url{https://hal.inria.fr/hal-01222915}. Python code: \url{https://team.inria.fr/sequel/software/POO}. \cr \cr
}
