% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbTocd.r
\name{dbTocd}
\alias{dbTocd}
\title{Convert perimetric dB to cd/\eqn{\mbox{m}^2}{m^2}}
\usage{
dbTocd(db, maxStim = 10000/pi)
}
\arguments{
\item{db}{Value to convert to cd/\eqn{\mbox{m}^2}{m^2}.}

\item{maxStim}{Stimulus value for 0dB in cd/\eqn{\mbox{m}^2}{m^2}.}
}
\value{
cd/\eqn{\mbox{m}^2}{m^2} value for \code{db} dB.
}
\description{
Given a value in dB, return the cd/\eqn{\mbox{m}^2}{m^2}
equivalent. Default is to use HFA units, so maximum stimulus is 10000
apostilbs.
}
\examples{
# decibels to candela
cd <- dbTocd(0)   # 10000/pi
cd <- dbTocd(10)  # 1000/pi
cd <- dbTocd(20)  # 100/pi
cd <- dbTocd(30)  # 10/pi
cd <- dbTocd(40)  # 1/pi
}
