% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opsr.R
\name{opsr}
\alias{opsr}
\title{Fitting Ordinal Probit Switching Regression Models}
\usage{
opsr(
  formula,
  data,
  subset,
  weights,
  na.action,
  start = NULL,
  fixed = NULL,
  method = "BFGS",
  iterlim = 1000,
  printLevel = 2,
  nThreads = 1,
  .get2step = FALSE,
  .useR = FALSE,
  .censorRho = TRUE,
  ...
)
}
\arguments{
\item{formula}{an object of class \verb{"Formula" "formula"}: A symbolic description
of the model to be fitted. The details of model specification are given under
'Details'.}

\item{data}{an optional data frame, list or environment (or object coercible by
\code{\link{as.data.frame}} to a data frame) containing the variables in the model. If
not found in \code{data}, the variables are taken from \code{environment(formula)},
typically the environment from which \code{opsr} is called.}

\item{subset}{an optional vector specifying a subset of observations to be used
in the fitting process. (See additional details in the 'Details' section of
the \code{\link{model.frame}} documentation.).}

\item{weights}{an optional vector of weights to be used in the fitting process.
Should be \code{NULL} or a numeric vector. If non-NULL, then observation-specific
log-likelihood contributions are multiplied by their corresponding weight
before summing.}

\item{na.action}{a function which indicates what should happen when the data
contain \code{NA}s. The default is set by the \code{na.action} setting of \code{\link{options}},
and is \code{\link{na.fail}} if that is unset. The 'factory-fresh' default is \code{\link{na.omit}}.
Another possible value is \code{NULL}, no action. Value \code{\link{na.exclude}} can be useful.}

\item{start}{a numeric vector with the starting values (passed to \code{\link[maxLik:maxLik]{maxLik::maxLik}}).
If no starting values are provided, reasonable values are auto-generated via
the Heckman 2-step procedure \code{\link{opsr_2step}}. The structure of \code{start} has to
conform with \code{opsr}'s expectations. See \code{\link{opsr_check_start}} for further details.}

\item{fixed}{parameters to be treated as constants at their \code{start} values. If
present, it is treated as an index vector of \code{start} parameters (passed to
\code{\link[maxLik:maxLik]{maxLik::maxLik}}).}

\item{method}{maximzation method (passed to \code{\link[maxLik:maxLik]{maxLik::maxLik}}).}

\item{iterlim}{maximum number of iterations (passed to \code{\link[maxLik:maxLik]{maxLik::maxLik}}).}

\item{printLevel}{larger number prints more working information (passed to \code{\link[maxLik:maxLik]{maxLik::maxLik}}).}

\item{nThreads}{number of threads to be used. Do not pass higher number than
number of ordinal outcomes. See also \code{\link{opsr_check_omp}} and \code{\link{opsr_max_threads}}.}

\item{.get2step}{if \code{TRUE}, returns starting values as generated by \code{\link{opsr_2step}}. Will
not proceed with the maximum likelihood estimation.}

\item{.useR}{if \code{TRUE} usese \code{\link{loglik_R}}. Go grab a coffe.}

\item{.censorRho}{if \code{TRUE}, rho starting values are censored to lie in the
interval [-0.85, 0.85].}

\item{...}{further arguments passed to \code{\link[maxLik:maxLik]{maxLik::maxLik}}.}
}
\value{
An object of class \verb{"opsr" "maxLik" "maxim"}.
}
\description{
High-level formula interface to the workhorse \code{\link{opsr.fit}}.
}
\details{
Models for \code{opsr} are specified symbolically. A typical model has the form
\code{ys | yo ~ terms_s | terms_o1 | terms_o2 | ...}. \code{ys} is the ordered (numeric)
response vector (starting from 1, in integer-increasing fashion). For the \code{terms}
specification the rules of the regular formula interface apply (see also \link[stats:lm]{stats::lm}).
The intercept in the \code{terms_s} (selection process) is excluded automatically
(no need to specify \code{-1}). If the user wants to specify the same process for
all continuous outcomes, two processes are enough (\code{ys | yo ~ terms_s | terms_o}).
Note that the model is poorly identifiable if \code{terms_s == terms_o} (same regressors
are used in selection and outcome processes).
}
\examples{
## simulated data
sim_dat <- opsr_simulate()
dat <- sim_dat$data  # 1000 observations
sim_dat$sigma  # cov matrix of errors
sim_dat$params  # ground truth

## specify a model
model <- ys | yo ~ xs1 + xs2 | xo1 + xo2 | xo1 + xo2 | xo1 + xo2
model <- ys | yo ~ xs1 + xs2 | xo1 + xo2  # since we use the same specification...

## estimate
fit <- opsr(model, dat)

## inference
summary(fit)

## using update and model comparison
fit_updated <- update(fit, ~ . | 1)  # only intercepts for the continuous outcomes
## null model
fit_null <- opsr_null_model(fit)

## likelihood ratio test
anova(fit_null, fit_updated, fit)

## predict
p1 <- predict(fit, group = 1, type = "response")
p2 <- predict(fit, group = 1, counterfact = 2, type = "response")
plot(p1, p2)
abline(a = 0, b = 1, col = "red")

## produce formatted tables
texreg::screenreg(fit, beside = TRUE, include.pseudoR2 = TRUE, include.R2 = TRUE)

}
