% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OSFD.R
\name{space_filling_points}
\alias{space_filling_points}
\title{Generate points to approximate a space based on existing points.}
\usage{
space_filling_points(X)
}
\arguments{
\item{X}{a matrix specifying the existing points}
}
\value{
a matrix of the generated points to approximate the space.
}
\description{
\code{space_filling_points} generates points to approximate a space based on existing points.
These approximate points can be used to find local fill distance in the space or be used as candidate points in active learning.
}
\details{
\code{space_filling_points} generates points to approximate a space based on existing points. Details can be found in  Wang et al. (2024).
}
\examples{

X = matrix(runif(20), ncol=2)
space_filling_points = space_filling_points(X)
plot(space_filling_points, type='p')

}
\references{
Wang, Shangkun, Adam P. Generale, Surya R. Kalidindi, and V. Roshan Joseph. (2024). "Sequential designs for filling output spaces", Technometrics, 66, 65–76.
}
