% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/SegFunctions.R
\name{Delta}
\alias{Delta}
\title{A function to compute Delta index}
\usage{
Delta(x, a = NULL, spatobj = NULL, folder = NULL, shape = NULL)
}
\arguments{
\item{x}{- an object of class matrix (or that can be coerced
to that class), where each column represents the distribution
of a population group, within spatial units. The number of
columns should be greater than one (at least two population
groups are required).}

\item{a}{- a vector with areas of spatial units}

\item{spatobj}{- a spatial object (SpatialPolygonsDataFrame)}

\item{folder}{- a character vector with the folder (directory)
where the shapefile is}

\item{shape}{- a character vector with the name of the shapefile
(without the .shp extension)}
}
\value{
A vector with Delta index
}
\description{
Delta index compares the relative density of a
spatial unit with the proportion of a group living in the
same unit. The function can be used in two ways: by providing
a vector with spatial units area, or a geographic source (spatial
object or shape file) wich will be used to compute the area vector
 within the function
}
\examples{
x <- slot(GreHSize, 'data')[ ,3:5]
ar <- area(GreHSize)
foldername <- system.file('extdata', package = 'OasisR')
shapename <- 'GreHSize'

Delta(x, a = ar)

Delta(x, spatobj = GreHSize)

Delta(x, folder = foldername, shape = shapename)
}
\references{
Duncan O. D., Cuzzoert  and Duncan B. (1961)
\emph{Problems in analyzing areal data}. Statistical geography,
Glencoe, Illinois: The free press of Glencoe
}
\seealso{
Absolute Concentration Index: \code{\link{ACO}}

Relative Concentration Index: \code{\link{RCO}}
}

