% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/SegFunctions.R
\name{Gini}
\alias{Gini}
\title{A function to compute Spatial Gini's segregation index}
\usage{
Gini(x)
}
\arguments{
\item{x}{- an object of class matrix (or that can be coerced
to that class), where each column represents the distribution
of a population group, within spatial units. The number of
columns should be greater than one (at least two population
groups are required).}
}
\value{
A vector with Gini segregation index
}
\description{
A spatial version of Gini index. It can be derived
from the Lorenz curve, and varies between 0 (minimum segregation)
and 1 (maximum segregation).
}
\examples{
x <- slot(GreHSize, 'data')[ ,3:5]
Gini(x)
}
\references{
Gini C. (1921) \emph{Measurement of inequality of income}.
Economic Journal 31, pp. 22-43
}
\seealso{
Other evenness intragroup  indices: \code{\link{Duncan}},
\code{\link{Morill}}, \code{\link{Wong}}, \code{\link{Gorard}}

Intergroup dissimilarity index: \code{\link{DI}}
}

