% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OmicsPLS.R
\name{loocv_combi}
\alias{loocv_combi}
\title{K-fold CV based on symmetrized prediction error}
\usage{
loocv_combi(
  X,
  Y,
  a = 1:2,
  a2 = 1,
  b2 = 1,
  fitted_model = NULL,
  func = o2m,
  app_err = F,
  kcv,
  stripped = TRUE,
  p_thresh = 3000,
  q_thresh = p_thresh,
  tol = 1e-10,
  max_iterations = 100
)
}
\arguments{
\item{X}{Numeric matrix. Vectors will be coerced to matrix with \code{as.matrix} (if this is possible)}

\item{Y}{Numeric matrix. Vectors will be coerced to matrix with \code{as.matrix} (if this is possible)}

\item{a}{Vector of integers. Contains the numbers of joint components.}

\item{a2}{Vector of integers. Contains the numbers of orthogonal components in \eqn{X}.}

\item{b2}{Vector of integers. Contains the numbers of orthogonal components in \eqn{Y}.}

\item{fitted_model}{List. Deprecated. O2PLS model fit with \code{\link{o2m}}. Is used to calculate the apparent error without recalculating this fit.}

\item{func}{Function to fit the O2PLS model with. Only \code{\link{o2m}} and \code{\link{o2m_stripped}} are supported.}

\item{app_err}{Logical. Deprecated. Should the apparent error also be computed?}

\item{kcv}{Integer. The value of \eqn{k}, i.e. the number of folds. Choose \eqn{N} for LOO-CV.}

\item{stripped}{Logical. Use the stripped version of o2m (usually when cross-validating)?}

\item{p_thresh}{Integer. If \code{X} has more than \code{p_thresh} columns, a power method optimization is used, see \code{\link{o2m2}}}

\item{q_thresh}{Integer. If \code{Y} has more than \code{q_thresh} columns, a power method optimization is used, see \code{\link{o2m2}}}

\item{tol}{Double. Threshold for which the NIPALS method is deemed converged. Must be positive.}

\item{max_iterations}{Integer. Maximum number of iterations for the NIPALS method.}
}
\value{
List with two numeric vectors:
\item{CVerr}{Contains the k-fold CV estimated RMSEP}
\item{Fiterr}{Contains the apparent error}
}
\description{
The prediction error of both \code{X~Xhat} and \code{Y~Yhat} are summed. This provides a symmetrized version of \code{\link{loocv}}.
}
\details{
Note that this function can be easily parallelized (on Windows e.g. with the \code{parallel} package.).
If there are NAs in the CVerr component, this is due to an error in the fitting.
}
