% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/global.R
\name{create_valid_excel}
\alias{create_valid_excel}
\title{Create a formatted Excel file based on validation rules}
\usage{
create_valid_excel(
  file_rules,
  negStyle = createStyle(fontColour = "#9C0006", bgFill = "#FFC7CE"),
  posStyle = createStyle(fontColour = "#006100", bgFill = "#C6EFCE"),
  row_num = 1000
)
}
\arguments{
\item{file_rules}{A CSV or Excel file containing validation rules.}

\item{negStyle}{Style to apply for negative conditions (default is red text on a pink background).}

\item{posStyle}{Style to apply for positive conditions (default is green text on a light green background).}

\item{row_num}{Number of rows to create in the output file (default is 1000).}
}
\value{
A workbook object containing the formatted Excel file.
}
\description{
This function creates an Excel file with conditional formatting and data validation
based on the given validation rules in a CSV or Excel file.
}
\examples{
\donttest{
data("test_rules")
create_valid_excel(file_rules = test_rules)
}}
