% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MxAlgebra.R
\name{mxAlgebraFromString}
\alias{mxAlgebraFromString}
\title{Create MxAlgebra object from a string}
\usage{
mxAlgebraFromString(algString, name = NA, dimnames = NA, ...)
}
\arguments{
\item{algString}{the character string to convert into an R expression}

\item{name}{An optional character string indicating the name of the object.}

\item{dimnames}{list. The dimnames attribute for the algebra: a list of length 2 giving the row and column names respectively. An empty list is treated as NULL, and a list of length one as row names. The list can be named, and the list names will be used as names for the dimensions.}

\item{...}{Not used.  Forces any remaining arguments to be specified by name.}
}
\description{
Create MxAlgebra object from a string
}
\examples{
A <- mxMatrix(values = runif(25), nrow = 5, ncol = 5, name = 'A')
B <- mxMatrix(values = runif(25), nrow = 5, ncol = 5, name = 'B')
model <- mxModel(A, B, name = 'model',
  mxAlgebraFromString("A * (B + A)", name = 'test'))
model <- mxRun(model)
model[['test']]$result
A$values * (B$values + A$values)
}
\seealso{
\link{mxAlgebra}
}

