% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MxCompute.R
\name{mxComputeEM}
\alias{MxComputeEM-class}
\alias{mxComputeEM}
\title{Fit a model using DLR's (1977) Expectation-Maximization (EM) algorithm}
\usage{
mxComputeEM(expectation, predict, mstep, observedFit = "fitfunction", ...,
  maxIter = 500L, tolerance = 1e-09, verbose = 0L,
  freeSet = NA_character_, accel = "varadhan2008",
  information = NA_character_, infoArgs = list())
}
\arguments{
\item{expectation}{a vector of expectation names}

\item{predict}{what to predict from the observed data (available options depend on the expectation)}

\item{mstep}{a compute plan to optimize the completed data model}

\item{observedFit}{the name of the observed data fit function (defaults to "fitfunction")}

\item{...}{Not used.  Forces remaining arguments to be specified by name.}

\item{maxIter}{maximum number of iterations}

\item{tolerance}{optimization is considered converged when the maximum relative change in fit is less than tolerance}

\item{verbose}{level of diagnostic output}

\item{freeSet}{names of matrices containing free variables}

\item{accel}{name of acceleration method ("varadhan2008" or "ramsay1975")}

\item{information}{name of information matrix approximation method}

\item{infoArgs}{arguments to control the information matrix method}
}
\description{
The EM algorithm constitutes the following steps: Start with an
initial parameter vector. Predict the missing data to form a
completed data model. Optimize the completed data model to obtain
a new parameter vector. Repeat these steps until convergence
criteria are met.
}
\details{
This compute plan does not work with any and all expectations. It
requires a special kind of expectation that can predict its
missing data to create a completed data model.

The EM algorithm does not produce a parameter covariance matrix
for standard errors. The Oakes (1999) direct method and S-EM, an
implementation of Meng & Rubin (1991), are included.

Ramsay (1975) was recommended in Bock, Gibbons, & Muraki (1988).
}
\references{
Bock, R. D., Gibbons, R., & Muraki, E. (1988). Full-information
item factor analysis. \emph{Applied Psychological Measurement,
6}(4), 431-444.

Dempster, A. P., Laird, N. M., & Rubin, D. B. (1977). Maximum likelihood from
incomplete data via the EM algorithm. \emph{Journal of the Royal Statistical Society.
Series B (Methodological)}, 1-38.

Meng, X.-L. & Rubin, D. B. (1991). Using EM to obtain asymptotic variance-covariance
matrices: The SEM algorithm. \emph{Journal of the American Statistical Association,
86} (416), 899-909.

Oakes, D. (1999). Direct calculation of the information matrix via
the EM algorithm.  \emph{Journal of the Royal Statistical Society:
Series B (Statistical Methodology), 61}(2), 479-482.

Ramsay, J. O. (1975). Solving implicit equations in psychometric data analysis.
\emph{Psychometrika, 40} (3), 337-360.

Varadhan, R. & Roland, C. (2008). Simple and globally convergent
methods for accelerating the convergence of any EM
algorithm. \emph{Scandinavian Journal of Statistics, 35}, 335-353.
}

