% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manage_lib.R
\name{check_lib}
\alias{check_lib}
\alias{get_lib}
\alias{load_lib}
\alias{rm_lib}
\title{Manage spectral libraries}
\usage{
check_lib(
  type = c("derivative", "nobaseline", "raw", "mediod", "model"),
  path = "system",
  condition = "warning"
)

get_lib(
  type = c("derivative", "nobaseline", "raw", "mediod", "model"),
  path = "system",
  node = "x7dpz",
  conflicts = "overwrite",
  ...
)

load_lib(type, path = "system")

rm_lib(
  type = c("derivative", "nobaseline", "raw", "mediod", "model"),
  path = "system"
)
}
\arguments{
\item{type}{library type to check/retrieve; defaults to
\code{c("derivative", "nobaseline", "raw", "mediod", "model")} which reads
everything.}

\item{path}{where to save or look for local library files; defaults to
\code{"system"} pointing to
\code{system.file("extdata", package = "OpenSpecy")}.}

\item{condition}{determines if \code{check_lib()} should warn
(\code{"warning"}, the default) or throw and error (\code{"error"}).}

\item{node}{the OSF node to be retrieved; should be \code{"x7dpz"} unless you
maintain your own OSF node with spectral libraries.}

\item{conflicts}{determines what happens when a file with the same name
exists at the specified destination. Can be one of the following (see
\code{\link[osfr]{osf_download}()} for details):
\itemize{
\item{"error"}{ throw an error and abort the file transfer operation.}
\item{"skip"}{ skip the conflicting file(s) and continue transferring the
remaining files.}
\item{"overwrite" (default)}{ replace the existing file with the
transferred copy.}
}}

\item{\ldots}{further arguments passed to \code{\link[osfr]{osf_download}()}.}
}
\value{
\code{check_lib()} and \code{get_lib()} return messages only;
\code{load_lib()} returns an \code{OpenSpecy} object containing the
respective spectral reference library.
}
\description{
These functions will import the spectral libraries from Open Specy if they
were not already downloaded.
The CRAN does not allow for deployment of large datasets so this was a
workaround that we are using to make sure everyone can easily get Open Specy
functionality running on their desktop.
}
\details{
\code{check_lib()} checks to see if the Open Specy reference library
already exists on the users computer.
\code{get_lib()} downloads the Open Specy library from OSF
(\doi{10.17605/OSF.IO/X7DPZ}).
\code{load_lib()} will load the library into the global environment for use
with the Open Specy functions.
\code{rm_lib()} removes the libraries from your computer.
}
\examples{
\dontrun{
check_lib("derivative")
get_lib("derivative")

spec_lib <- load_lib("derivative")
}

}
\references{
Cowger W, Gray A, Christiansen SH, De Frond H, Deshpande AD, Hemabessiere L,
Lee E, Mill L, et al. (2020). “Critical Review of Processing and
Classification Techniques for Images and Spectra in Microplastic Research.”
\emph{Applied Spectroscopy}, \strong{74}(9), 989–1010.
\doi{10.1177/0003702820929064}.

Cowger, W (2021). “Library data.” \emph{OSF}. \doi{10.17605/OSF.IO/X7DPZ}.
}
\author{
Zacharias Steinmetz, Win Cowger
}
